CREATE SCHEMA IF NOT EXISTS TCad;

CREATE TYPE TCad.cad_trigger AS ENUM (
    'btPrepared',   -- Erstellt
    'btChecked',    -- Geprüft
    'btApproved',   -- Freigegeben
    'btClear',      -- Status entfernen
    'btCheckInOut', -- Wechsel Ein-/Auschecken
    'btSync',       -- Sync Button
    'btOpenPath',   -- Pfad öffnen Button
    'viewDocuments',-- Rechtsklick auf eine Datei in der Komponente viewDocuments
    'DoubleClick'   -- Doppelklick auf eine Datei in der Komponente viewDocuments
);

CREATE TABLE IF NOT EXISTS TCad.PathPart(
    pp_id    SERIAL PRIMARY KEY,
    pp_dtid    VARCHAR(30) NOT NULL, -- Dokumententyp
    pp_group    SMALLINT NOT NULL,
    pp_value    VARCHAR(200) NOT NULL,
    pp_adkrz    VARCHAR(21) NOT NULL
);

CREATE TABLE IF NOT EXISTS TCad.CadDocTypes (
    cdt_id    SERIAL PRIMARY KEY,
    cdt_dtid    VARCHAR(30)  NOT NULL, -- Dokumententyp
    cdt_type    VARCHAR(10) NOT NULL,
    cdt_pfx    VARCHAR(10), -- Präfix
    cdt_sfx    VARCHAR(10), -- Suffix
    cdt_fn    VARCHAR(100) NOT NULL -- String für Dateibenennung Felder in [] Klammern als Wildcard
);

-- Dynamischer Sync
CREATE TABLE TCad.CADSyncItems(
  csi_id            SERIAL PRIMARY KEY,
  csi_item          VARCHAR(100) NOT NULL,
  csi_query         TEXT,
  csi_autosync      BOOLEAN NOT NULL DEFAULT TRUE,
  csi_whencheckout  BOOLEAN NOT NULL DEFAULT TRUE,
  csi_whencheckin   BOOLEAN NOT NULL DEFAULT TRUE,
  csi_whenprepared  BOOLEAN NOT NULL DEFAULT TRUE,
  csi_whenchecked   BOOLEAN NOT NULL DEFAULT TRUE,
  csi_whenapproved  BOOLEAN NOT NULL DEFAULT TRUE
);

CREATE UNIQUE INDEX CADSyncItems_item ON TCad.CADSyncItems (csi_item);

-- Aktionen je Dateityp
CREATE TABLE TCad.CADActions(
  cac_id                    SERIAL PRIMARY KEY,
  cac_dtid                  VARCHAR(30) REFERENCES dokutypes ON UPDATE CASCADE, -- Dokumententyp aus Tabelle
  cac_fileext               VARCHAR(5), -- Dateityp mit führendem Punkt z.B. .pdf oder .prt
  cac_trigger               TCad.cad_trigger NOT NULL,  -- Auslöser der Aktion
  cac_action_order          INTEGER,    -- Reihfolge der Ausführung bei mehreren Aktionen
  cac_action_textno         INTEGER,    -- Aktion Beschreibung (Angezeigt bei Rechtsklick)
  cac_action                VARCHAR,    -- Aktion
  cac_action_params         VARCHAR,    -- Parameter der Aktion
  cac_with_doc              BOOLEAN,    -- Soll diese Aktion angeboten werden wenn es ein Dokument gibt?
  cac_with_status           BOOLEAN DEFAULT false,    -- Ist die Action abhängig von der Eigenschaft "art.status.cad"
  cac_cad_status            VARCHAR(5),  -- Darstellung nur bei Eigenschaft "art.status.cad" mit diesem Wert
  cac_hint                  VARCHAR     -- Hinweis zur Aktion
);